<?php
/**
 * @version $Id: joomag.php,v 1.5.5 $
 * @copyright (C) 2012 Joomag
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL
 */
 /** ensure this file is being included by a parent file */
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport( 'joomla.plugin.plugin' );
class plgContentJoomag extends JPlugin
{
    function _j_getValueWithDefault($regex, $params, $default)
    {
        $matchCount = preg_match_all($regex, $params, $matches);
        if ($matchCount) {
            return $matches[1][0];
        } else {
            return $default;
        }
    }

    function onContentPrepare($context, &$article, &$params, $limitStart)
    {
        // For Joomla 1.6
        $this->joomag_parser($article, $params, $limitStart);

    }

    function onPrepareContent(&$article, &$params, $limitStart)
    {
        // For Joomla 1.5
        $this->joomag_parser($article, $params, $limitStart);

    }


    function joomag_parser($row, $params, $page = 0)
    {
        $regex = '/\[joomag ([^]]*)\]/i';
        preg_match_all($regex, $row->text, $matches);
        for ($x = 0; $x < count($matches[0]); $x++) {
            $replace = $this->joomag_get_magazine($matches[0][$x]);
            $row->text = str_replace($matches[0][$x], $replace, $row->text);
        }

        $regex = '/\[joomag_bookshelf ([^]]*)\]/i';
        preg_match_all($regex, $row->text, $matches);
        for ($x = 0; $x < count($matches[0]); $x++) {
            $replace = $this->joomag_get_bookshelf($matches[0][$x]);
            $row->text = str_replace($matches[0][$x], $replace, $row->text);
        }
    }

    function joomag_get_bookshelf($matches)
    {
        $height				 =	$this->_j_getValueWithDefault('/(?:^|[\s]+)height=([\S]*)/i', $matches, 460);
       	$width				 =	$this->_j_getValueWithDefault('/(?:^|[\s]+)width=([\S]*)/i', $matches, 450);
       	$magazineId			 =	$this->_j_getValueWithDefault('/(?:^|[\s]+)magazineId=([\S]*)/i', $matches, '');
       	$title				 =	$this->_j_getValueWithDefault('/(?:^|[\s]+)title=([\S]*)/i', $matches, '');
       	$cols				 =	$this->_j_getValueWithDefault('/(?:^|[\s]+)cols=([\S]*)/i', $matches, 3);
       	$rows				 =	$this->_j_getValueWithDefault('/(?:^|[\s]+)rows=([\S]*)/i', $matches, 2);
       
       	$embedCodeStr =  '<iframe name="Joomag_embed_${UUID}"'.
       					 ' style="width:${width};height:${height}" width="${width}" height="${height}" hspace="0" vspace="0" frameborder="0" '.
       					 ' src="${bookshelfURL}&cols=${cols}&rows=${rows}"></iframe>' ;
       
       	$domain = 'www.joomag.com';
       
       	$bookshelfURL = '//' . $domain . '/Frontend/embed/bookshelf/index.php?UID=' . $magazineId;
       
       	$UUID = sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
       	  mt_rand(0, 0xffff), mt_rand(0, 0xffff),
       	  mt_rand(0, 0xffff),
       	  mt_rand(0, 0x0fff) | 0x4000,
       	  mt_rand(0, 0x3fff) | 0x8000,
       	  mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
       	);
       
       	$embedCodeStr = str_replace('${bookshelfURL}', $bookshelfURL, $embedCodeStr);
       	$embedCodeStr = str_replace('${width}', $width.'px', $embedCodeStr);
       	$embedCodeStr = str_replace('${height}', $height.'px', $embedCodeStr);
       	$embedCodeStr = str_replace('${cols}', $cols, $embedCodeStr);
       	$embedCodeStr = str_replace('${rows}', $rows, $embedCodeStr);
       	$embedCodeStr = str_replace('${UUID}', $UUID, $embedCodeStr);
       
       	return $embedCodeStr;
    }

    function joomag_get_magazine($matches)
    {
        $height				 =	$this->_j_getValueWithDefault('/(?:^|[\s]+)height=([\S]*)/i', $matches, 272);
        $width				 =	$this->_j_getValueWithDefault('/(?:^|[\s]+)width=([\S]*)/i', $matches, 420);
        $pageNumber			 =	$this->_j_getValueWithDefault('/(?:^|[\s]+)pageNumber=([\S]*)/i', $matches, 1);
        $magazineId			 =	$this->_j_getValueWithDefault('/(?:^|[\s]+)magazineId=([\S]*)/i', $matches, '');
        $title				 =	$this->_j_getValueWithDefault('/(?:^|[\s]+)title=([\S]*)/i', $matches, '');
        $backgroundColor	 =	$this->_j_getValueWithDefault('/(?:^|[\s]+)backgroundColor=([\S]*)/i', $matches, '');
        $backgroundImg		 =	$this->_j_getValueWithDefault('/(?:^|[\s]+)backgroundImage=([\S]*)/i', $matches, '');
        $toolbar		     =	$this->_j_getValueWithDefault('/(?:^|[\s]+)toolbar=([\S]*)/i', $matches, '');
        $autoFlip		     =	$this->_j_getValueWithDefault('/(?:^|[\s]+)autoFlip=([\S]*)/i', $matches, '');
        $autoFit			 =	$this->_j_getValueWithDefault('/(?:^|[\s]+)autoFit=([\S]*)/i', $matches, 'false') == 'true' ? true : false;

        $embedCodeStr =  '<IFRAME NAME="Joomag_embed_${UUID}"'.
                         ' style="width:${width};height:${height}" WIDTH="${width}" HEIGHT="${height}" HSPACE="0" VSPACE="0" frameborder="0" '.
                         ' SRC="${magURL}?page=${startPage}&e=1${otherOptions}"></IFRAME>' ;

        $domain = 'www.joomag.com';

        $viewerURL = '//' . $domain . '/magazine/' . $title . '/' . $magazineId;

        $embedOpts = array();
        if($toolbar != '')
        {
            switch( $toolbar ) {
                case 'none':
                    array_push($embedOpts, 'noToolbar');
                    break;
                case 'transparent':
                    array_push($embedOpts, 'none');
                    break;
                default:
                    array_push($embedOpts, "solid,{$toolbar}");
                    break;
            }
        }

        if($backgroundColor != '')
        {
            $bgColors = explode(',', $backgroundColor);

            if( $backgroundColor == 'transparent' ) {
                array_push($embedOpts, 'none');
            } elseif( is_array($bgColors) && count($bgColors) == 2 ) {
                array_push($embedOpts, "gradient,{$backgroundColor}");
            } else {
                array_push($embedOpts, "solid,{$backgroundColor}");
            }
        } else if( $backgroundImg != '' ) {
            array_push($embedOpts, "image,{$backgroundImg},fill");
        }

        $embedOptsStr = '&embedInfo=' . implode(';', $embedOpts);
        if( is_numeric($autoFlip) ) {
            $embedOptsStr .= "&autoFlipDelay={$autoFlip}";
        }

        if( $autoFit == true ) {
            $embedCodeStr = str_replace('${width}', '100%', $embedCodeStr);
            $embedCodeStr = str_replace('${height}', '100%', $embedCodeStr);}
        else {
            $embedCodeStr = str_replace('${width}', $width.'px', $embedCodeStr);
            $embedCodeStr = str_replace('${height}', $height.'px', $embedCodeStr);
        }

        $embedCodeStr = str_replace('${startPage}', $pageNumber, $embedCodeStr);

        $embedCodeStr = str_replace('${otherOptions}', $embedOptsStr, $embedCodeStr);

        $UUID = sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
          mt_rand(0, 0xffff), mt_rand(0, 0xffff),
          mt_rand(0, 0xffff),
          mt_rand(0, 0x0fff) | 0x4000,
          mt_rand(0, 0x3fff) | 0x8000,
          mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
        );

        $embedCodeStr = str_replace('${magURL}', $viewerURL, $embedCodeStr);
        $embedCodeStr = str_replace('${UUID}', $UUID, $embedCodeStr);

        return $embedCodeStr;
    }

}
 ?>